<?php

declare(strict_types=1);

/*
 * This file is part of the RegexParser package.
 *
 * (c) Younes ENNAJI <younes.ennaji.pro@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace RegexParser\Automata\Model;

use RegexParser\Automata\Alphabet\CharSet;

/**
 * NFA transition labeled with a character set.
 */
final readonly class NfaTransition
{
    /**
     * @param CharSet $charSet Transition label
     * @param int     $target  Target state id
     */
    public function __construct(
        public CharSet $charSet,
        public int $target,
    ) {}
}
